<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Invoice</title>
    <!-- Bootstrap 5 CSS -->
    <link href="http://localhost:8000/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;700&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="<?php echo e(versionedAsset('custom/css/print/print.css')); ?>">
</head>
<body>
    <!-- To switch to RTL, add dir="rtl" to the div below -->
    <h2 class="page-title">Purchase Order</h2>
    <div class="invoice" dir="ltr">
        <div class="company-header company-header border-bottom border-default">
            <img src=<?php echo e("/company/getimage/" . app('company')['colored_logo']); ?> alt="Company Logo" class="company-logo">
            <div class="company-name">
                <h2><?php echo e(app('company')['name']); ?></h2>
                <p class="company-contact"><?php echo e(app('company')['address']); ?></p>
                <?php if(app('company')['mobile'] || app('company')['email']): ?>
                <p class="company-contact">
                <?php echo e(app('company')['mobile'] ? 'M: '. app('company')['mobile'] : ''); ?><?php echo e(app('company')['email'] ? ', Mail: '.app('company')['email'] : ''); ?></p>
                <?php endif; ?>
            </div>
            <div class="bill-info">
                <p class="bill-number">Bill #: <?php echo e($order->order_code); ?></p>
                <p><?php echo e(__('order.date')); ?>: <?php echo e($order->formatted_order_date); ?></p>
                <p><?php echo e(__('app.due_date')); ?>: <?php echo e($formatDate->toUserDateFormat($order->due_date)); ?></p>
            </div>
        </div>
        <div class="clearfix address-container">
            <div class="address address-box">
                <strong><?php echo e(__('app.order_to')); ?></strong><br>
                <?php echo e($order->party->first_name.' '. $order->party->last_name); ?><br>
                <?php echo e($order->party->billing_address); ?>

            </div>
            <div class="address address-box">
                <strong><?php echo e(__('app.ship_from')); ?></strong><br>
                <?php echo e($order->party->shipping_address); ?>

            </div>
        </div>

        <?php
            $isHasBatchItem = ($order->itemTransaction->where('tracking_type', 'batch')->count() > 0) ? true : false;

            //Return from Controller
            $totalBatchTrackingRowCount = ($isHasBatchItem) ? $batchTrackingRowCount : 0;
        ?>
        <table class="table table-bordered custom-table table-compact" id="item-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(__('item.item')); ?></th>
                    <th><?php echo e(__('item.hsn')); ?></th>
                    <?php if($isHasBatchItem): ?>
                        <th class="<?php echo e(!app('company')['enable_batch_tracking'] ? 'd-none':''); ?>"><?php echo e(__('item.batch_no')); ?></th>
                        <th class="<?php echo e(!app('company')['enable_mfg_date'] ? 'd-none':''); ?>"><?php echo e(__('item.mfg_date')); ?></th>
                        <th class="<?php echo e(!app('company')['enable_exp_date'] ? 'd-none':''); ?>"><?php echo e(__('item.exp_date')); ?></th>
                        <th class="<?php echo e(!app('company')['enable_model'] ? 'd-none':''); ?>"><?php echo e(__('item.model_no')); ?></th>
                        <th class="<?php echo e(!app('company')['show_mrp'] ? 'd-none':''); ?>"><?php echo e(__('item.mrp')); ?></th>
                        <th class="<?php echo e(!app('company')['enable_color'] ? 'd-none':''); ?>"><?php echo e(__('item.color')); ?></th>
                        <th class="<?php echo e(!app('company')['enable_size'] ? 'd-none':''); ?>"><?php echo e(__('item.size')); ?></th>
                    <?php endif; ?>
                    <th><?php echo e(__('app.qty')); ?></th>
                    <th><?php echo e(__('app.price_per_unit')); ?></th>
                    <th><?php echo e(__('app.discount')); ?></th>
                    <th><?php echo e(__('tax.tax')); ?></th>
                    <th><?php echo e(__('app.total')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $i=1;
                ?>

                <?php $__currentLoopData = $order->itemTransaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="no"><?php echo e($i++); ?></td>
                    <td class="text-left">
                        <!-- Service Name -->
                        <b><?php echo e($transaction->item->name); ?></b>
                        <!-- Description -->
                        <small><?php echo e($transaction->description); ?></small>
                   </td>
                   <td>
                       <?php echo e($transaction->item->hsn); ?>

                   </td>
                   <?php if($isHasBatchItem): ?>
                   <td class="<?php echo e(!app('company')['enable_batch_tracking'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $transaction->batch->batch_no : ''); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['enable_mfg_date'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->mfg_date) : ''); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['enable_exp_date'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $formatDate->toUserDateFormat($transaction->batch->exp_date) : ''); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['enable_model'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $transaction->batch->model_no : ''); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['show_mrp'] ? 'd-none':''); ?> text-end">
                       <?php echo e($transaction->batch ? $formatNumber->formatWithPrecision($transaction->batch->mrp) : '0.00'); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['enable_color'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $transaction->batch->color :''); ?>

                   </td>
                   <td class="<?php echo e(!app('company')['enable_size'] ? 'd-none':''); ?>">
                       <?php echo e($transaction->batch ? $transaction->batch->size : ''); ?>

                   </td>
                   <?php endif; ?>
                   <td class="text-end">
                        <?php echo e($formatNumber->formatQuantity($transaction->quantity)); ?>

                    </td>
                    <td class=" text-end">
                        <?php echo e($formatNumber->formatWithPrecision(calculatePrice($transaction->unit_price, $transaction->tax->rate,  needInclusive: ($transaction->tax_type == 'inclusive' ? true : false) ))); ?>

                    </td>
                    <td class=" text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->discount_amount)); ?><br>
                        <small>
                            (<?php echo e($formatNumber->formatWithPrecision($transaction->discount_amount)); ?>

                                <?php echo e(($transaction->discount_type == 'fixed') ? '$' : '%'); ?>)
                        </small>
                    </td>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->tax_amount)); ?><br>
                        <small>(<?php echo e($transaction->tax->rate); ?>%)</small>
                    </td>
                    <td class="text-end">
                        <?php echo e($formatNumber->formatWithPrecision($transaction->total)); ?>

                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <?php
                $subtotal = $order->itemTransaction->sum(function ($transaction) {
                            if($transaction->tax_type == 'inclusive'){
                                $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: true);
                            }else{
                                $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: false);
                            }
                                return $unitPrice * $transaction->quantity;
                        });
                $discount = $order->itemTransaction->sum(function ($transaction) {
                            return $transaction->discount_amount;
                        });

                $taxAmount = $order->itemTransaction->sum(function ($transaction) {
                            return $transaction->tax_amount;
                        });

                ?>
                <tr>
                    <td colspan="<?php echo e(3+ $totalBatchTrackingRowCount); ?>" rowspan="4" class="tfoot-first-td">
                        <span class="invoice-note">Note:<br></span><?php echo e($order->note); ?>

                    </td>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.subtotal')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($subtotal)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.discount')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($discount)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('tax.tax')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($taxAmount)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.round_off')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->round_off)); ?></td>
                </tr>
                <tr>
                    <td colspan="<?php echo e(3+ $totalBatchTrackingRowCount); ?>" rowspan="3" class="tfoot-first-td">
                        <b><?php echo e(__('app.amount_in_words')); ?>:<br></b>
                    </td>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('app.grand_total')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->grand_total)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('payment.paid_amount')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->paid_amount)); ?></td>
                </tr>
                <tr>
                    <td colspan="2" class="text-end fw-bold"><?php echo e(__('payment.balance')); ?></td>
                    <td colspan="1" class="text-end"><?php echo e($formatNumber->formatWithPrecision($order->grand_total - $order->paid_amount)); ?></td>
                </tr>

            </tfoot>
        </table>
        <?php if(app('company')['show_tax_summary']): ?>
        <table class="table table-bordered custom-table tax-breakdown table-compact">
            <thead>
                <?php if(app('company')['tax_type'] == 'tax'): ?>
                    <tr>
                        <th><?php echo e(__('tax.tax')); ?></th>
                        <th><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?></th>
                        <th><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                 <?php else: ?>
                    
                     <tr>
                        <th rowspan="2"><?php echo e(__('item.hsn')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.cgst')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.sgst')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.igst')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                    <tr>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                    </tr>
                <?php endif; ?>
            </thead>
            <tbody>
                <?php

                if(app('company')['tax_type'] == 'tax'){
                    $taxSummary = $order->itemTransaction
                        ->groupBy('tax_id')
                        ->map(function ($group) {
                            $firstItem = $group->first();
                            $totalTaxableAmount = $group->sum(function ($item) use ($firstItem) {
                                $totalOfEachItem = ($item->unit_price-$item->discount_amount) * $item->quantity;
                                if ($item->tax_type == 'inclusive') {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: true);
                                } else {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: false);
                                }
                            });
                            return [
                                'tax_id' => $firstItem->tax_id,
                                'tax_name' => $firstItem->tax->name,
                                'tax_rate' => $firstItem->tax->rate,
                                'total_taxable_amount' => $totalTaxableAmount,
                                'total_tax' => $group->sum('tax_amount')
                            ];
                        })
                        ->values();
                }
                else{
                    //GST
                    $taxSummary = $order->itemTransaction
                    ->groupBy('item.hsn') // First group by HSN
                    ->map(function ($hsnGroup) {
                        return $hsnGroup->groupBy('tax_id') // Then group by tax_id within each HSN group
                            ->map(function ($group) {
                                $firstItem = $group->first();
                                $totalTaxableAmount = $group->sum(function ($item) {
                                    $totalOfEachItem = ($item->unit_price - $item->discount_amount) * $item->quantity;
                                    if ($item->tax_type == 'inclusive') {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: true);
                                    } else {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: false);
                                    }
                                });
                                return [
                                    'hsn' => $firstItem->item->hsn,
                                    'tax_id' => $firstItem->tax_id,
                                    'tax_name' => $firstItem->tax->name,
                                    'tax_rate' => $firstItem->tax->rate,
                                    'total_taxable_amount' => $totalTaxableAmount,
                                    'total_tax' => $group->sum('tax_amount')
                                ];
                            });
                    })
                    ->flatMap(function ($hsnGroup) {
                        return $hsnGroup;
                    })
                    ->values();
                }

                ?>
                <?php $__currentLoopData = $taxSummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(app('company')['tax_type'] == 'tax'): ?>
                    <tr>
                        <td><?php echo e($summary['tax_name']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>
                        <td class="text-center"><?php echo e($summary['tax_rate']); ?>%</td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php else: ?>
                    <tr>
                        <td><?php echo e($summary['hsn']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>

                        <?php
                            $cs_gst = $i_gst = '';
                            $cs_gst_amt = $i_gst_amt = '';
                            if(app('company')['state_id'] == $order->state_id){
                                $cs_gst = ($summary['tax_rate']/2).'%';
                                $cs_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']/2);
                            }else{
                                $i_gst = ($summary['tax_rate']).'%';
                                $i_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']);
                            }
                        ?>
                        <!-- CGST & SGT -->
                        <td class="text-center"><?php echo e($cs_gst); ?></td>
                        <td class="text-end"><?php echo e($cs_gst_amt); ?></td>
                        <td class="text-center"><?php echo e($cs_gst); ?></td>
                        <td class="text-end"><?php echo e($cs_gst_amt); ?></td>
                        <!-- IGST -->
                        <td class="text-center"><?php echo e($i_gst); ?></td>
                        <td class="text-end"><?php echo e($i_gst_amt); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endif; ?>
        <?php if(app('company')['show_terms_and_conditions_on_invoice']): ?>
        <div class="terms-and-conditions">
            <strong><?php echo e(__('app.terms_and_conditions')); ?></strong><br>
            <span class="cu-fs-1 "><?php echo nl2br(app('company')['terms_and_conditions']); ?></span>
        </div>
        <?php endif; ?>

        <div class="bottom-section clearfix">
            <div class="bank-details">
                <strong><?php echo e(__('app.bank_details')); ?></strong><br>
                <p style=""><?php echo nl2br(app('company')['bank_details']); ?></p>
            </div>
            <div class="signature-box">
                <div class="signature-content">
                    <?php if(app('company')['show_signature_on_invoice']): ?>
                    <img src="<?php echo e("/company/signature/getimage/".app('company')['signature']); ?>" alt="Signature" class="signature-image">
                    <?php endif; ?>
                    <p><?php echo e(app('company')['name']); ?></p>
                    <p><?php echo e(__('app.authorized_signatory')); ?></p>
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo e(versionedAsset('assets/js/jquery.min.js')); ?>"></script>
</body>
</html>
<?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/purchase/order/unused-print.blade.php ENDPATH**/ ?>