<!DOCTYPE html>
<html lang="en" dir="<?php echo e($appDirection); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($invoiceData['name']); ?></title>
    <link href="<?php echo e(versionedAsset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(versionedAsset('custom/css/print/pos.css')); ?>"/>
</head>
<body onload="window.print();">
    <div class="invoice-wrapper">
        <div class="container mt-3">
            <div class="invoice-header">
                <div class="invoice-title"><?php echo e(app('company')['name']); ?></div>
                <div>
                    <?php echo e(app('company')['address']); ?>

                        <p>
                            <?php if(app('company')['mobile'] || app('company')['email']): ?>
                                <?php echo e(app('company')['mobile'] ? 'M: '. app('company')['mobile'] : ''); ?><?php echo e(app('company')['email'] ? ', Mail: '.app('company')['email'] : ''); ?>

                            <?php endif; ?>
                        </p>
                </div>
            </div>

            <div class="text-center">--------<?php echo e($invoiceData['name']); ?>--------</div>

            <div class="row">
                <div class="col-6">
                    <div><?php echo e(__('app.name')); ?>: <?php echo e($purchase->party->first_name.' '. $purchase->party->last_name); ?></div>
                    <div><?php echo e(__('app.mobile')); ?>: <?php echo e($purchase->party->mobile); ?></div>
                    <div><?php echo e(__('purchase.seller')); ?>: <?php echo e($purchase->user->first_name.' '. $purchase->user->last_name); ?></div>
                </div>
                <div class="col-6 text-end">
                    <div><?php echo e(__('purchase.invoice')); ?>: #SL0040</div>
                    <div><?php echo e(__('app.date')); ?>: <?php echo e($purchase->formatted_purchase_date); ?></div>
                    <div><?php echo e(__('app.time')); ?>: <?php echo e($purchase->format_created_time); ?></div>
                </div>
            </div>

            <table class="table table-sm mt-2">
                <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('app.description')); ?></th>
                        <th class="text-end"><?php echo e(__('app.price_per_unit')); ?></th>
                        <th class="text-end"><?php echo e(__('app.qty')); ?></th>
                        <th class="text-end"><?php echo e(__('app.total')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $i=1;
                    ?>

                    <?php $__currentLoopData = $purchase->itemTransaction; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($i++); ?></td>
                        <td>
                            <?php echo e($transaction->item->name); ?>

                            <small><?php echo e($transaction->description); ?></small>
                            <small>
                                <?php if($transaction->itemSerialTransaction->count() > 0): ?>
                                    <br><?php echo e($transaction->itemSerialTransaction->pluck('itemSerialMaster.serial_code')->implode(',')); ?><br>
                                <?php endif; ?>
                            </small>
                        </td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($transaction->total/$transaction->quantity)); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatQuantity($transaction->quantity)); ?></td>


                        
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($transaction->total)); ?></td>



                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php
                       $totalQty = $purchase->itemTransaction->sum(function ($transaction) {
                            return $transaction->quantity;
                        });
                    ?>
                    <tr class="text-end fw-bold">
                        <td colspan="3"><?php echo e(__('app.total')); ?></td>
                        <td><?php echo e($formatNumber->formatQuantity($totalQty)); ?></td>
                        <td><?php echo e($formatNumber->formatWithPrecision($purchase->grand_total)); ?></td>
                    </tr>
                </tbody>
            </table>

            <div class="row text-end">
                <?php
                    $subtotal = $purchase->itemTransaction->sum(function ($transaction) {
                                /*if($transaction->tax_type == 'inclusive'){
                                    $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: true);
                                }else{
                                    $unitPrice = calculatePrice($transaction->unit_price, $transaction->tax->rate, needInclusive: false);
                                }*/
                                $unitPrice = $transaction->unit_price;
                                return $unitPrice * $transaction->quantity;
                            });
                    $discount = $purchase->itemTransaction->sum(function ($transaction) {
                                return $transaction->discount_amount;
                            });

                    $taxAmount = $purchase->itemTransaction->sum(function ($transaction) {
                                return $transaction->tax_amount;
                            });

                ?>
                <div class="col-8 text-end"><strong><?php echo e(__('app.subtotal')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($subtotal)); ?></div>

                <?php if(app('company')['show_discount']): ?>
                <div class="col-8 text-end"><strong><?php echo e(__('app.discount')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision(-$discount)); ?></div>
                <?php endif; ?>

                <?php if(app('company')['tax_type'] != 'no-tax'): ?>
                    <div class="col-8 text-end"><strong><?php echo e(__('tax.tax')); ?></strong></div>
                    <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($taxAmount)); ?></div>
                <?php endif; ?>

                <div class="col-8 text-end"><strong><?php echo e(__('app.round_off')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($purchase->round_off)); ?></div>

                <div class="col-8 text-end"><strong><?php echo e(__('app.grand_total')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($purchase->grand_total)); ?></div>

                <div class="col-8 text-end"><strong><?php echo e(__('payment.paid_amount')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($purchase->paid_amount)); ?></div>

                <div class="col-8 text-end"><strong><?php echo e(__('payment.balance')); ?></strong></div>
                <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($purchase->grand_total - $purchase->paid_amount)); ?></div>


                <?php if(app('company')['show_mrp']): ?>
                    <?php
                        $savedAmount = $purchase->itemTransaction->sum(function ($transaction) {
                                    if($transaction->mrp > 0){
                                        return ($transaction->mrp * $transaction->quantity) - $transaction->total;
                                    }else{
                                        return 0;
                                    }
                            });

                    ?>
                    <div class="col-8 text-end"><strong><?php echo e(__('app.you_saved')); ?></strong></div>
                    <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($savedAmount)); ?></div>
                <?php endif; ?>

                <?php if(app('company')['show_party_due_payment']): ?>
                    <?php
                        $partyTotalDue = $purchase->party->getPartyTotalDueBalance();
                        $partyTotalDueBalance = $partyTotalDue['balance'];
                    ?>
                <tr>
                    <div class="col-8 text-end"><strong><?php echo e(__('app.previous_due')); ?></strong></div>
                    <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($partyTotalDueBalance - ($purchase->grand_total - $purchase->paid_amount) )); ?></div>
                </tr>
                <tr>
                    <div class="col-8 text-end"><strong><?php echo e(__('app.total_due_balance') . ($partyTotalDue['status'] == 'you_pay' ? '(You Pay)' : '(Receive)')); ?></strong></div>
                    <div class="col-4"><?php echo e($formatNumber->formatWithPrecision($partyTotalDueBalance)); ?></div>
                </tr>
                <?php endif; ?>


            </div>

            <?php if(app('company')['show_tax_summary'] && app('company')['tax_type'] != 'no-tax'): ?>
        <table class="table table-bordered custom-table tax-breakdown table-compact">
            <thead>
                <?php if(app('company')['tax_type'] == 'tax'): ?>
                    <tr>
                        <th><?php echo e(__('tax.tax')); ?></th>
                        <th><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th><?php echo e(__('tax.rate')); ?></th>
                        <th><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                 <?php else: ?>
                    
                     <tr>
                        <th rowspan="2"><?php echo e(__('item.hsn')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.taxable_amount')); ?></th>
                        <th colspan="2" class="text-center"><?php echo e(__('tax.gst')); ?></th>
                        <th rowspan="2"><?php echo e(__('tax.tax_amount')); ?></th>
                    </tr>
                    <tr>
                        <th><?php echo e(__('tax.rate')); ?>%</th>
                        <th><?php echo e(__('app.amount')); ?></th>
                    </tr>
                <?php endif; ?>
            </thead>
            <tbody>
                <?php

                if(app('company')['tax_type'] == 'tax'){
                    $taxSummary = $purchase->itemTransaction
                        ->groupBy('tax_id')
                        ->map(function ($group) {
                            $firstItem = $group->first();
                            $totalTaxableAmount = $group->sum(function ($item) use ($firstItem) {
                                $totalOfEachItem = ($item->unit_price-$item->discount_amount) * $item->quantity;
                                return $totalOfEachItem;
                                /*
                                if ($item->tax_type == 'inclusive') {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: true);
                                } else {
                                    return calculatePrice($totalOfEachItem, $firstItem->tax->rate, needInclusive: false);
                                }*/
                            });
                            return [
                                'tax_id' => $firstItem->tax_id,
                                'tax_name' => $firstItem->tax->name,
                                'tax_rate' => $firstItem->tax->rate,
                                'total_taxable_amount' => $totalTaxableAmount,
                                'total_tax' => $group->sum('tax_amount')
                            ];
                        })
                        ->values();
                }
                else{
                    //GST
                    $taxSummary = $purchase->itemTransaction
                    ->groupBy('item.hsn') // First group by HSN
                    ->map(function ($hsnGroup) {
                        return $hsnGroup->groupBy('tax_id') // Then group by tax_id within each HSN group
                            ->map(function ($group) {
                                $firstItem = $group->first();
                                $totalTaxableAmount = $group->sum(function ($item) {
                                    $totalOfEachItem = ($item->unit_price - $item->discount_amount) * $item->quantity;
                                    return $totalOfEachItem;
                                    /*
                                    if ($item->tax_type == 'inclusive') {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: true);
                                    } else {
                                        return calculatePrice($totalOfEachItem, $item->tax->rate, needInclusive: false);
                                    }*/
                                });
                                return [
                                    'hsn' => $firstItem->item->hsn,
                                    'tax_id' => $firstItem->tax_id,
                                    'tax_name' => $firstItem->tax->name,
                                    'tax_rate' => $firstItem->tax->rate,
                                    'total_taxable_amount' => $totalTaxableAmount,
                                    'total_tax' => $group->sum('tax_amount')
                                ];
                            });
                    })
                    ->flatMap(function ($hsnGroup) {
                        return $hsnGroup;
                    })
                    ->values();
                }

                ?>
                <?php $__currentLoopData = $taxSummary; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $summary): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(app('company')['tax_type'] == 'tax'): ?>


                    <tr>
                        <td><?php echo e($summary['tax_name']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>
                        <td class="text-center"><?php echo e($summary['tax_rate']); ?>%</td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php else: ?>
                    <tr>
                        <?php
                            $isCSGST = (empty($purchase->state_id) || app('company')['state_id'] == $purchase->state_id) ? true:false;
                        ?>
                        <td><?php echo e($summary['hsn']); ?></td>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_taxable_amount'])); ?></td>

                        <?php
                            $cs_gst = $i_gst = '';
                            $cs_gst_amt = $i_gst_amt = '';
                            if($isCSGST){
                                $cs_gst = ($summary['tax_rate']/2).'%';
                                $cs_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']/2);
                            }else{
                                $i_gst = ($summary['tax_rate']).'%';
                                $i_gst_amt = $formatNumber->formatWithPrecision($summary['total_tax']);
                            }
                        ?>
                        <?php if($isCSGST): ?>
                            <!-- CGST & SGT -->
                            <td class="text-center"><?php echo e($cs_gst); ?></td>
                            <td class="text-end"><?php echo e($cs_gst_amt); ?></td>
                        <?php else: ?>
                            <!-- IGST -->
                            <td class="text-center"><?php echo e($i_gst); ?></td>
                            <td class="text-end"><?php echo e($i_gst_amt); ?></td>
                        <?php endif; ?>
                        <td class="text-end"><?php echo e($formatNumber->formatWithPrecision($summary['total_tax'])); ?></td>
                    </tr>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <?php endif; ?>


        </div>
    </div>
    <div class="container mt-3 mb-3">
        <button class="btn btn-success print-btn" onclick="window.print()">Print</button>
    </div>

    <!-- Bootstrap JS -->
    <script src="<?php echo e(versionedAsset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(versionedAsset('assets/js/jquery.min.js')); ?>"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            window.print();
        });
    </script>
</body>
</html>
<?php /**PATH /home/eltaqwa/public_html/delta-source-code/resources/views/print/purchase/thermal.blade.php ENDPATH**/ ?>