@extends('layouts.error')

@section('title', __('tenant.not_active_title'))

@section('content')
<div style="text-align: center; padding: 60px;">
    <h1 style="font-size: 36px; color: orange;">{{ __('tenant.not_active_title') }}</h1>
    <p style="font-size: 18px;">{{ __('tenant.not_active_msg') }}</p>
    <a href="{{ url('/') }}" class="btn btn-outline-primary mt-3">{{ __('tenant.back_home') }}</a>
</div>
@endsection
@section('content')
<div class="min-h-screen flex flex-col items-center justify-center bg-gray-100 px-4 text-center">
    @if(config('app.logo'))
        <img src="{{ asset('storage/' . config('app.logo')) }}" alt="Logo" class="h-20 mb-6">
    @endif

    <h1 class="text-3xl font-bold text-red-600">{{ __('tenant.not_active_title') }}</h1>
    <p class="text-gray-700 mt-2">{{ __('tenant.not_active_msg') }}</p>

    <div class="mt-6 flex gap-3 justify-center flex-wrap">
        <a href="{{ url('/') }}" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
            {{ __('tenant.back_home') }}
        </a>
        <a href="mailto:support@eltaqwa.cc" class="px-4 py-2 bg-gray-200 text-gray-800 rounded hover:bg-gray-300">
            📧 تواصل عبر البريد
        </a>
        <a href="https://wa.me/201234567890" target="_blank" class="px-4 py-2 bg-green-500 text-white rounded hover:bg-green-600">
            💬 تواصل واتساب
        </a>
    </div>
</div>
@endsection