<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

use Illuminate\Database\Eloquent\Relations\Relation;
use App\Models\Items\Item;
use App\Models\Party\Party;
use App\Models\Party\PartyTransaction;
use App\Models\Twilio;
use App\Models\AppSettings;
use App\Models\SmtpSettings;
use App\Models\Purchase\PurchaseOrder;
use App\Models\Purchase\Purchase;
use App\Models\Purchase\PurchaseReturn;

use App\Models\Sale\SaleOrder;
use App\Models\Sale\Sale;
use App\Models\Sale\SaleReturn;

use App\Models\PaymentTransaction;
use App\Models\Items\ItemTransaction;
use App\Models\Expenses\Expense;
use App\Models\CashAdjustment;
use App\Models\StockTransfer;
use App\Observers\TwilioObserver;
use App\Services\GeneralDataService;
use App\Services\SmsService;
use Illuminate\Support\Facades\Route;
use App\Services\CacheService;
use App\Enums\App;
use App\Models\Party\PartyPayment;
use App\Models\Sale\Quotation;
use App\Models\StockAdjustment;
use App\Models\Tenant;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        if(env('INSTALLATION_STATUS')){
            $this->app->singleton(GeneralDataService::class, function ($app) {
                return new GeneralDataService();
            });

            $this->app->singleton(SmsService::class, function ($app) {
                return new SmsService();
            });

            /*$this->app->singleton('site', function () {
                $appSettings = CacheService::get('appSetting');//AppSettings::find(App::APP_SETTINGS_RECORD_ID->value);
                return [
                    'name'              => $appSettings ? $appSettings->application_name : null,
                    'colored_logo'      => $appSettings ? $appSettings->colored_logo : null,
                ];
            });*/
            
            
            /*********************/
            
            
            $this->app->singleton('site', function () {
    try {
        // الآن نحن في قاعدة بيانات التينانت بعد الاتصال
        $appSettings = \App\Models\AppSettings::first();

        // ضبط إعدادات Laravel نفسها
        if ($appSettings) {
            config([
                'app.name' => $appSettings->application_name,
                'app.logo' => $appSettings->colored_logo,
                'app.fevicon' => $appSettings->fevicon,
                'app.footer_text' => $appSettings->footer_text,
            ]);
        }

        return [
            'name'         => $appSettings?->application_name,
            'colored_logo' => $appSettings?->colored_logo,
        ];
    } catch (\Throwable $e) {
        logger()->error('فشل تحميل إعدادات التينانت: ' . $e->getMessage());
        return [
            'name' => null,
            'colored_logo' => null,
        ];
    }
});

            
            /*********************************/
            $this->app->singleton('smtp_settings', function () {
                $smtpSettings = CacheService::get('smtpSettings');//SmtpSettings::find(App::APP_SETTINGS_RECORD_ID->value);//
                return [
                    'host'       => $smtpSettings->host,
                    'port'       => $smtpSettings->port,
                    'username'   => $smtpSettings->username,
                    'password'   => $smtpSettings->password,
                    'encryption' => $smtpSettings->encryption,
                ];
            });
        }
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        
        
        
        if (!$this->app->runningInConsole()) {
        $host = request()->getHost(); // client1.eltaqwa.cc
        $subdomain = explode('.', $host)[0]; // client1

        // 👇 الاتصال بقاعدة بيانات system فقط للبحث عن العميل
        $tenant = Tenant::where('subdomain', $subdomain)->first();
    if ($subdomain !== 'eltaqwa') {
        
        
        if (!$tenant) {
    abort(response()->view('errors.tenant.not-found', [], 404));
}

if (!$tenant->is_active) {
    abort(response()->view('errors.tenant.not-active', [], 403));
}

if ($tenant->expires_at && now()->greaterThan($tenant->expires_at)) {
    abort(response()->view('errors.tenant.expired', [], 403));
}

        /*
        if (!$tenant) {
    return response()->view('errors.tenant.not-found', [], 404);
}

if (!$tenant->is_active) {
    return response()->view('errors.tenant.not-active', [], 403);
}

if ($tenant->expires_at && now()->greaterThan($tenant->expires_at)) {
    return response()->view('errors.tenant.expired', [], 403);
}

        
        
        
            // ✅ لم يتم العثور على التينانت
            if (!$tenant) {
                abort(404, 'لم يتم العثور على الصب دومين.');
            }

            // ✅ غير مفعل
            if (!$tenant->is_active) {
                abort(403, 'الحساب غير مفعل.');
            }

            // ✅ منتهي الصلاحية
            if ($tenant->expires_at && now()->greaterThan($tenant->expires_at)) {
                abort(403, 'انتهت صلاحية الحساب.');
            }*/
        
        /*
        
        return response()->view('errors.tenant-not-found', [], 404);
if (request()->wantsJson()) {
    return response()->json(['error' => '...'], 403);
}

        
        */
        
        if ($tenant) {
            Config::set('database.connections.tenant', [
                'driver' => 'mysql',
                'host' => '127.0.0.1',
                'port' => '3306',
                'database' => $tenant->database,
                'username' => 'eltaqwa_pos_user',
                'password' => '4?%!_1qO%49,z@kM',
                'charset' => 'utf8mb4',
                'collation' => 'utf8mb4_unicode_ci',
                'prefix' => '',
                'strict' => true,
                'engine' => null,
            ]);
            DB::setDefaultConnection('tenant');
            DB::purge('tenant');
            DB::reconnect('tenant');

            app()->instance('tenant', $tenant);
            
        }
    }
        }
      
        
        
        
        if(env('INSTALLATION_STATUS')){
                       // إعدادات SMTP
            $this->app->singleton('smtp_settings', function () {
                $smtpSettings = CacheService::get('smtpSettings');
                return [
                    'host' => $smtpSettings->host ?? '',
                    'port' => $smtpSettings->port ?? '',
                    'username' => $smtpSettings->username ?? '',
                    'password' => $smtpSettings->password ?? '',
                    'encryption' => $smtpSettings->encryption ?? '',
                ];
            });

            // تعيين إعدادات البريد
            try {
                $smtp = $this->app->make('smtp_settings');
                config([
                    'mail.driver' => 'smtp',
                    'mail.host' => $smtp['host'],
                    'mail.port' => $smtp['port'],
                    'mail.username' => $smtp['username'],
                    'mail.password' => $smtp['password'],
                    'mail.encryption' => $smtp['encryption'],
                ]);
            } catch (\Throwable $e) {
                logger()->error('SMTP settings failed: ' . $e->getMessage());
            }
        }

        Relation::morphMap([
            'Item Opening'              =>  Item::class, //Used in ItemTransaction class,

            'Purchase Order'            =>  PurchaseOrder::class,//Used in ItemTransaction class,

            'Purchase'                  =>  Purchase::class,//Used in ItemTransaction class,

            'Purchase Return'           =>  PurchaseReturn::class,//Used in ItemTransaction class,

            'Sale Order'                =>  SaleOrder::class,//Used in ItemTransaction class,

            'Sale'                      =>  Sale::class,//Used in ItemTransaction class,

            'Sale Return'               =>  SaleReturn::class,//Used in ItemTransaction class,

            'Party Opening'             =>  Party::class,//Used in PartyTransaction class

            'Payment Transaction'       =>  PaymentTransaction::class,//Used in PaymentTransaction class

            'Expense'                   =>  Expense::class,//Used in PaymentTransaction class

            'Party Transaction'         =>  PartyTransaction::class,//Used in AccountTransaction class

            'Item Transaction'          =>  ItemTransaction::class,//Used in AccountTransaction class

            'Cash Adjustment'           =>  CashAdjustment::class,//Used in CashController class

            'Stock Transfer'            =>  StockTransfer::class,//Used in CashController class

            'Stock Adjustment'          =>  StockAdjustment::class,

            'Party Payment'            =>  PartyPayment::class,//Used in PartyTransactionController class

            'Quotation'                =>  Quotation::class,//Used in ItemTransaction class,

        ]);
    }
}
